# Python tornado 框架

tornado 服务，极简路由

```python
# -*- coding: UTF-8 -*-
import tornado.web
import tornado.ioloop

class IndexHandler(tornado.web.RequestHandler):
    """主路由处理类"""

    def get(self):
        """对应http的get请求方式"""
        # TODO(You): 实现Tornado get 方法

if __name__ == "__main__":
    app = tornado.web.Application([
        (r"/", IndexHandler),
    ])
    app.listen(8000)

    print("* Tornado Web Server 已在 8000 端口启动。")
    print("* 请在浏览器里输入 127.0.0.1:8000")
    tornado.ioloop.IOLoop.current().start()
```

请选出下列能**正确**实现这一功能的选项。

## template

```python
import tornado.web
import tornado.ioloop


class IndexHandler(tornado.web.RequestHandler):
    """主路由处理类"""

    def get(self):
        """对应http的get请求方式"""
        self.write("Hello Tornado!")

if __name__ == "__main__":
    app = tornado.web.Application([
        (r"/", IndexHandler),
    ])
    app.listen(8000)
    print("* Tornado Web Server 已在 8000 端口启动。")
    print("* 请在浏览器里输入 127.0.0.1:8000")
    tornado.ioloop.IOLoop.current().start()
```

## 答案

```python
class IndexHandler(tornado.web.RequestHandler):
    def get(self):
        self.write("Hello Tornado!")
```

## 选项

### A

```python
class IndexHandler(tornado.web.RequestHandler):
    def get(self):
        return "Hello Tornado!"
```

### B

```python
class IndexHandler(tornado.web.RequestHandler):
    def get(self):
        self.write("Hello Tornado!", 200)
```

### C

```python
class IndexHandler(tornado.web.RequestHandler):
    def get(self):
        self.write_error("Hello Tornado!", 500)
```
